

PROCEDURE LEVELSCHEDULING(
       M,N     :INTEGER;
   VAR NRI     :ARRN1;
   VAR INARC   :ARRN2;
   VAR SCHEDULE:ARRN);

   VAR I,J,L,P,R,S,T,U,V       :INTEGER;
       FATHER,INDEG,LEVEL,LIST,
       OUTDEG,READY,TIME,SETLAB:ARRN;
       NRO                     :ARRN1;
       OUTARC                  :ARRN2;

   PROCEDURE OUTARCREP(VAR OUTDEG:ARRN;VAR NRO:ARRN1;
                       VAR OUTARC:ARRN2);
      { THIS PROCEDURE CONSTRUCTS FORWARD-STAR REPRESENTATION }
      VAR I,J,K,L:INTEGER;
          AUX    :ARRN;
   BEGIN
      FOR I:=1 TO N DO NRO[I]:=0;
      FOR J:=1 TO N DO
         FOR L:=NRI[J] TO NRI[J+1]-1 DO BEGIN
            I:=INARC[L];  NRO[I]:=NRO[I]+1
         END;
      J:=1;
      FOR I:=1 TO N DO BEGIN
         L:=NRO[I];  OUTDEG[I]:=L;
         NRO[I]:=J;  AUX[I]:=J;
         J:=J+L
      END;
      NRO[N+1]:=J;
      FOR J:=1 TO N DO
         FOR L:=NRI[J] TO NRI[J+1]-1 DO BEGIN
            I:=INARC[L];  K:=AUX[I];
            OUTARC[K]:=J;  AUX[I]:=K+1
         END
   END;  { OUTARCREP - FORWARD-STAR REPRESENTATION }

   PROCEDURE LEVELLIST(VAR LEVEL,LIST:ARRN);
      { THIS PROCEDURE EVALUATES NODE LEVELS AND ORDERS
        NODES ACCORDING TO NONINCREASING LEVEL }
      VAR I,J,K,L,LEV,P,Q:INTEGER;
          AUX            :ARRN;
   BEGIN
      FOR I:=1 TO N DO AUX[I]:=OUTDEG[I];
      P:=N;
      FOR I:=1 TO N DO
         IF AUX[I] = 0 THEN BEGIN
            LEVEL[I]:=1;  LIST[P]:=I;
            P:=P-1
         END;
      Q:=N;
      WHILE (P > 0) AND (P < Q) DO BEGIN
         J:=LIST[Q];  Q:=Q-1;
         LEV:=LEVEL[J]+1;
         FOR L:=NRI[J] TO NRI[J+1]-1 DO BEGIN
            I:=INARC[L];  K:=AUX[I]-1;
            IF K <> 0 THEN AUX[I]:=K
            ELSE BEGIN
               LEVEL[I]:=LEV;  LIST[P]:=I;
               P:=P-1
            END
         END  { FOR L }
      END  { WHILE (P > 0) ... }
   END;  { LEVELLIST }

   FUNCTION FIND(I:INTEGER):INTEGER;
      { THIS FUNCTION FINDS THE SET CONTAINING I }
      VAR PTR,X,Y:INTEGER;
   BEGIN
      PTR:=I;
      WHILE FATHER[PTR] > 0 DO PTR:=FATHER[PTR];
      X:=I;
      WHILE FATHER[X] > 0 DO BEGIN
         Y:=FATHER[X];  FATHER[X]:=PTR;
         X:=Y
      END;
      FIND:=PTR
   END;  { FIND }

   PROCEDURE MERGE(U,V :INTEGER);
      { THIS PROCEDURE MERGES TWO SETS U AND V }
      VAR X:INTEGER;
   BEGIN
      X:=FATHER[U]+FATHER[V];
      IF FATHER[U] > FATHER[V] THEN BEGIN
         FATHER[U]:=V;  FATHER[V]:=X
      END
      ELSE BEGIN
         FATHER[V]:=U;  FATHER[U]:=X;
         SETLAB[U]:=SETLAB[V]
      END
   END;  { MERGE }

BEGIN                                                   { MAIN BODY }
   OUTARCREP(OUTDEG,NRO,OUTARC);
   LEVELLIST(LEVEL,LIST);
   FOR I:=1 TO N DO BEGIN
      INDEG[I]:=NRI[I+1]-NRI[I];
      FATHER[I]:=-1;  SETLAB[I]:=I;
      TIME[I]:=M
   END;  { FOR I }
   FOR I:=1 TO N DO  READY[I]:=1;
   P:=1;
   WHILE P <= N DO BEGIN
      I:=LIST[P];   P:=P+1;                     { PROCESSING NODE I }
      T:=READY[I];  U:=FIND(T);
      R:=SETLAB[U];  SCHEDULE[I]:=R;
      S:=TIME[R]-1;
      IF S > 0 THEN TIME[R]:=S
      ELSE BEGIN
         V:=FIND(R+1);  MERGE(U,V)
      END;
      FOR L:=NRO[I] TO NRO[I+1]-1 DO BEGIN
         J:=OUTARC[L];  INDEG[J]:=INDEG[J]-1;
         IF READY[J] < R+1 THEN READY[J]:=R+1
      END
   END  { WHILE P <= N }
END;  { LEVELSCHEDULING }

